import pandas as pd  
import pickle 
from decision_company import read_csv_file, check_elements_in_list, extract_unique_values, convert_np_to_list, series_get_quantile
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Identify additional customer segments with potential for responsiveness to promotions and financing options  
# Criteria: customers with a good credit history and a high credit amount  
good_credit_history = check_elements_in_list(credit_customers['credit_history'], ['no credits/all paid'])  
high_credit_amount = credit_customers['credit_amount'] > series_get_quantile(credit_customers['credit_amount'], q=0.75)  
  
# Combine the filters and apply them to the dataset  
potential_customers = credit_customers[good_credit_history & high_credit_amount]  
  
# Extract the additional customer segments  
additional_customer_segments = convert_np_to_list(extract_unique_values(potential_customers['cluster']))  

print("additional_customer_segments:\n", additional_customer_segments)    
pickle.dump(additional_customer_segments,open("./ref_result/additional_customer_segments.pkl","wb"))